<%@page import="java.util.Collection"%>
<%@page import="gov.va.med.pharmacy.peps.common.vo.ProductVo"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@taglib prefix="peps" tagdir="/WEB-INF/tags"%>
<%@taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<c:choose>

	<c:when test="${matchVo.unmatchedList == null}">
		<div class="noDataText"></div>
	</c:when>
	<c:otherwise>
	
		<c:choose>
			<c:when test="${empty matchVo.unmatchedList}">
				<div class="noDataText">No unmatched Products To Display</div>
			</c:when>

			<c:otherwise>
				<div class="horizontalspacer"></div>
				<fieldset>
					<legend class="boldText">Unmatched Products</legend>
					<table id="unmatchedProductsTable" frame="box" rules="cols"
						class="pepsTable">
						<thead>
							<tr>
								<th width="40%"><peps:label key="va.product.name" abbreviation="true" /></th>
								<th width="5%"><peps:label key="cmop.id" abbreviation="false" /></th>
								<th width="40%"><peps:label key="rematched.va.product.name" abbreviation="true" /></th>
								<th width="5%"><peps:label key="rematched.cmop.id" abbreviation="true" /></th>
								<th width="10%"><peps:label key="matched.scope" abbreviation="true" /></th>
							</tr>
						</thead>
						<tbody>
							<c:forEach var="unmatchedProduct" items="${matchVo.unmatchedList}" begin="0" varStatus="status">
	                             <tr class="${status.index % 2 == 0 ? 'even' : 'odd'}"> 							
									<c:choose>
										<c:when test="${unmatchedProduct.productName == null}">
											<td width="40%"><peps:text item="${unmatchedProduct}"
													key="va.product.name" value="" /></td>
										</c:when>
										<c:otherwise>
											<td width="40%"><a href="/PRE/rematch.go?id=${unmatchedProduct.id}"><c:out
														value="${unmatchedProduct.productName}" /></a></td>
										</c:otherwise>
									</c:choose>
									<c:choose>
										<c:when test="${unmatchedProduct.cmop == null}">
											<td width="5%"><peps:text item="${unmatchedProduct}" key="cmop.id"
													value="" /></td>
										</c:when>
										<c:otherwise>
											<td width="5%"><peps:text item="${unmatchedProduct}" key="cmop.id"
													value="${unmatchedProduct.cmop}" /></td>
										</c:otherwise>
									</c:choose>
									<c:choose>
										<c:when test="${unmatchedProduct.matchedProductName == null}">
											<td width="40%"><peps:text item="${unmatchedProduct}"
													key="rematched.va.product.name" value="" /></td>
										</c:when>
										<c:otherwise>
											<td width="40%"><peps:text item="${unmatchedProduct}"
													key="rematched.va.product.name"
													value="${unmatchedProduct.matchedProductName}" /></td>
										</c:otherwise>
									</c:choose>
									<c:choose>
										<c:when test="${unmatchedProduct.matchedCmop == null}">
											<td width="5%"><peps:text item="${unmatchedProduct}" key="rematched.cmop.id"
													value="" /></td>
										</c:when>
										<c:otherwise>
											<td width="5%"><peps:text item="${unmatchedProduct}" key="rematched.cmop.id"
													value="${unmatchedProduct.matchedCmop}" /></td>
										</c:otherwise>
									</c:choose>
									<c:choose>
										<c:when test="${unmatchedProduct.matchedScope == null}">
											<td width="10%"><peps:text item="${unmatchedProduct}" key="matched.scope"
													value="" /></td>
										</c:when>
										<c:otherwise>
											<td width="10%"><peps:text item="${unmatchedProduct}" key="matched.scope"
													value="${unmatchedProduct.matchedScope}" /></td>
										</c:otherwise>
									</c:choose>
								</tr>
							</c:forEach>
						</tbody>
					</table>
				</fieldset>
			</c:otherwise>
		</c:choose>

	</c:otherwise>
</c:choose>

